package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Color;
import net.miginfocom.swing.MigLayout;
import util.Utility;

import javax.swing.JTextField;

import music.Album;
import music.Performer;
import music.Song;

import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JButton;
import java.awt.Dimension;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.awt.event.ActionEvent;
import javax.swing.SwingConstants;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class MainAppWindow {

	private JFrame frmAlbum;
	private JPanel northPanel;
	private JPanel southPanel;
	private JPanel eastPanel;
	private JPanel centralPanel;
	private JLabel lblAlbum;
	private JLabel lblReleaseDate;
	private JLabel lblSpecificReleaseDate;
	private JLabel lblCredits;
	private JTextArea creditsTextArea;
	private JButton btnSave;
	private final ButtonGroup buttonGroup = new ButtonGroup();
	private JLabel lblDetails;
	
	private Album album;
	private LinkedList<Song> songs = new LinkedList<Song>();
	private NewSongDialog newSongDialog;
	private Song song;
	
	private JPanel westPanel;
	private JLabel lblTitle;
	private JTextField titleTextField;
	private JLabel lblPerformer;
	private JTextField performerTextField;
	private JLabel lblSongs;
	private JComboBox songsComboBox;
	private JButton btnTest;
	private JSplitPane splitPane;
	private JScrollPane leftScrollPane;
	private JScrollPane rightScrollPane;
	private JTextArea lyricsTextArea;
	private JLabel lblPicture;
	private JRadioButton rdbtnBasic;
	private JRadioButton rdbtnStandard;
	private JRadioButton rdbtnAll;
	private JMenuBar menuBar;
	private JMenu mnFile;
	private JMenu mnEdit;
	private JMenu mnHelp;
	private JMenuItem mntmNewAlbum;
	private JMenuItem mntmNewSong;
	private JMenuItem mntmOpen;
	private JMenuItem mntmSave;
	private JMenuItem mntmExit;
	private JSeparator separator;
	private JSeparator separator_1;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmAlbum.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmAlbum = new JFrame();
		frmAlbum.setTitle("Sgt. Pepper");
		frmAlbum.setBounds(100, 100, 860, 549);
		frmAlbum.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmAlbum.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmAlbum.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmAlbum.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmAlbum.getContentPane().add(getCentralPanel(), BorderLayout.CENTER);
		frmAlbum.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmAlbum.setJMenuBar(getMenuBar());
		
		createResourcesDir();
		album = Album.deserialize(Utility.createSubdir("resources") + "\\sgt.serialized");
		populateSongsComboBox();	}
	
	private void createResourcesDir() {
		Utility.createSubdir("resources");
	}

	private Album getAlbum() {
		if (album == null) {
			album = new Album();
			album.setTitle(titleTextField.getText());
			album.setPerformer(new Performer(performerTextField.getText()));
			album.setCredits(null);
//			album.setSongs((Song[]) songs.toArray());
			album.setSongs(songs.toArray(new Song[0]));
		}
		return album;
	}
	
	private void populateSongsComboBox() {
		for (int i = 0; i < album.getSongs().length; i++) {
			songsComboBox.addItem(album.getSongs()[i].getTitle());
		}
//		songsComboBox.addItem("Sgt. Pepper's Lonely Hearts Club Band");
//		songsComboBox.addItem("With a Little Help from My Friends");
//		songsComboBox.addItem("Lucy in the Sky with Diamonds");
	}
	
	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.setFont(new Font("Tahoma", Font.BOLD, 20));
			FlowLayout flowLayout = (FlowLayout) northPanel.getLayout();
			northPanel.add(getLblAlbum());
		}
		return northPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][][][][grow]", "[][]"));
			southPanel.add(getLblDetails(), "cell 1 0 3 1,alignx center");
			southPanel.add(getRdbtnBasic(), "cell 1 1");
			southPanel.add(getRdbtnStandard(), "cell 2 1");
			southPanel.add(getRdbtnAll(), "cell 3 1");
		}
		return southPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setMinimumSize(new Dimension(150, 10));
			eastPanel.setPreferredSize(new Dimension(150, 10));
			eastPanel.setLayout(new MigLayout("", "[grow]", "[][][][grow][]"));
			eastPanel.add(getLblReleaseDate(), "cell 0 0");
			eastPanel.add(getLblSpecificReleaseDate(), "cell 0 1");
			eastPanel.add(getLblCredits(), "cell 0 2");
			eastPanel.add(getCreditsTextArea(), "cell 0 3,grow");
			eastPanel.add(getBtnSave(), "cell 0 4,growx");
		}
		return eastPanel;
	}
	private JPanel getCentralPanel() {
		if (centralPanel == null) {
			centralPanel = new JPanel();
			centralPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
			centralPanel.add(getSplitPane(), "cell 0 0,grow");
		}
		return centralPanel;
	}
	private JLabel getLblAlbum() {
		if (lblAlbum == null) {
			lblAlbum = new JLabel("Album");
			lblAlbum.setForeground(new Color(0, 128, 128));
			lblAlbum.setFont(new Font("Tahoma", Font.BOLD, 14));
		}
		return lblAlbum;
	}
	private JLabel getLblReleaseDate() {
		if (lblReleaseDate == null) {
			lblReleaseDate = new JLabel("Release date");
		}
		return lblReleaseDate;
	}
	private JLabel getLblSpecificReleaseDate() {
		if (lblSpecificReleaseDate == null) {
			lblSpecificReleaseDate = new JLabel("");
			lblSpecificReleaseDate.setForeground(new Color(0, 191, 255));
		}
		return lblSpecificReleaseDate;
	}
	private JLabel getLblCredits() {
		if (lblCredits == null) {
			lblCredits = new JLabel("Credits");
		}
		return lblCredits;
	}
	private JTextArea getCreditsTextArea() {
		if (creditsTextArea == null) {
			creditsTextArea = new JTextArea();
		}
		return creditsTextArea;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					getAlbum().serialize(Utility.createSubdir("resources") + "\\sgt.serialized");
					Album a = Album.deserialize(Utility.createSubdir("resources") + "\\sgt.serialized");
					System.out.println(a);
				}
			});
		}
		return btnSave;
	}
	private JLabel getLblDetails() {
		if (lblDetails == null) {
			lblDetails = new JLabel("Details");
			lblDetails.setForeground(new Color(128, 0, 128));
			lblDetails.setFont(new Font("Tahoma", Font.BOLD, 13));
		}
		return lblDetails;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
		}
		lyricsTextArea.setLineWrap(true);
		lyricsTextArea.setWrapStyleWord(true);
		return lyricsTextArea;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setLayout(new MigLayout("", "[grow]", "[][][][][][][grow][]"));
			westPanel.add(getLabel_1(), "cell 0 0");
			westPanel.add(getTitleTextField(), "cell 0 1,growx");
			westPanel.add(getLabel_2(), "cell 0 2");
			westPanel.add(getPerformerTextField(), "cell 0 3,growx");
			westPanel.add(getLabel_3(), "cell 0 4");
			westPanel.add(getSongsComboBox(), "cell 0 5,growx");
			westPanel.add(getBtnTest(), "cell 0 7,growx");
		}
		return westPanel;
	}
	private JLabel getLabel_1() {
		if (lblTitle == null) {
			lblTitle = new JLabel("Title");
		}
		return lblTitle;
	}
	private JTextField getTitleTextField() {
		if (titleTextField == null) {
			titleTextField = new JTextField();
			titleTextField.setColumns(10);
		}
		return titleTextField;
	}
	private JLabel getLabel_2() {
		if (lblPerformer == null) {
			lblPerformer = new JLabel("Performer");
		}
		return lblPerformer;
	}
	private JTextField getPerformerTextField() {
		if (performerTextField == null) {
			performerTextField = new JTextField();
			performerTextField.setColumns(10);
		}
		return performerTextField;
	}
	private JLabel getLabel_3() {
		if (lblSongs == null) {
			lblSongs = new JLabel("Songs");
		}
		return lblSongs;
	}
	private JComboBox getSongsComboBox() {
		if (songsComboBox == null) {
			songsComboBox = new JComboBox();
			songsComboBox.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					if (arg0.getStateChange() == ItemEvent.SELECTED) {
						for (int i = 0; i < album.getSongs().length; i++) {
							if ((String) songsComboBox.getSelectedItem() == album.getSongs()[i].getTitle()) {
								getLyricsTextArea().setText(album.getSongs()[i].getLyrics());
								break;
							}
						}
					}
				}
			});
			songsComboBox.setMaximumSize(new Dimension(150, 32767));
		}
		return songsComboBox;
	}
	private JButton getBtnTest() {
		if (btnTest == null) {
			btnTest = new JButton("Test");
			btnTest.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					Song s = new Song();
					s.setTitle((String) songsComboBox.getSelectedItem());
					s.setLyrics(lyricsTextArea.getText());
					songs.add(s);
//					System.out.println(s);
//					System.out.println((String) songsComboBox.getSelectedItem());
					JOptionPane.showMessageDialog(frmAlbum,
						    "Song saved.");
				}
			});
		}
		return btnTest;
	}
	private JSplitPane getSplitPane() {
		if (splitPane == null) {
			splitPane = new JSplitPane();
			splitPane.setLeftComponent(getLeftScrollPane());
			splitPane.setRightComponent(getRightScrollPane());
			splitPane.setDividerLocation(150);
			splitPane.setOneTouchExpandable(true);
		}
		return splitPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLyricsTextArea_1());
		}
		return leftScrollPane;
	}
	private JScrollPane getRightScrollPane() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
			rightScrollPane.setViewportView(getLblPicture());
		}
		return rightScrollPane;
	}
	private JTextArea getLyricsTextArea_1() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
			lyricsTextArea.setLineWrap(true);
			lyricsTextArea.setWrapStyleWord(true);
		}
		return lyricsTextArea;
	}
	private JLabel getLblPicture() {
		if (lblPicture == null) {
			lblPicture = new JLabel("");
			lblPicture.setHorizontalAlignment(SwingConstants.CENTER);
//			lblPicture.setIcon(new ImageIcon("K:\\Vladan\\Downloads\\Auxiliary Eclipse Workspace\\Sgt. Pepper, Mon 10-12, 11.12.2017\\resources\\sgt.jpg"));
			lblPicture.setIcon(new ImageIcon(Utility.createSubdir("resources") + "\\sgt.jpg"));
		}
		return lblPicture;
	}
    private JRadioButton getRdbtnBasic() {
        if (rdbtnBasic == null) {
            rdbtnBasic = new JRadioButton("Basic");
            rdbtnBasic.addItemListener(new ItemListener() {
                public void itemStateChanged(ItemEvent arg0) {
                    getCentralPanel().setVisible(false);
                    getLblReleaseDate().setVisible(false);
                    getLblSpecificReleaseDate().setVisible(false);
                    getLblCredits().setVisible(false);
                    getCreditsTextArea().setVisible(false);
                    getBtnSave().setVisible(false);
                }
            });
            buttonGroup.add(rdbtnBasic);
        }
        return rdbtnBasic;
    }
    private JRadioButton getRdbtnStandard() {
        if (rdbtnStandard == null) {
            rdbtnStandard = new JRadioButton("Standard");
            rdbtnStandard.addItemListener(new ItemListener() {
                public void itemStateChanged(ItemEvent arg0) {
                    getCentralPanel().setVisible(true);
                    getLblReleaseDate().setVisible(false);
                    getLblSpecificReleaseDate().setVisible(false);
                    getLblCredits().setVisible(false);
                    getCreditsTextArea().setVisible(false);
                    getBtnSave().setVisible(false);
                }
            });
            buttonGroup.add(rdbtnStandard);
            rdbtnStandard.setSelected(true);
        }
        return rdbtnStandard;
    }
    private JRadioButton getRdbtnAll() {
        if (rdbtnAll == null) {
            rdbtnAll = new JRadioButton("All");
            rdbtnAll.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent arg0) {
                    getCentralPanel().setVisible(true);
                    getLblReleaseDate().setVisible(true);
                    getLblSpecificReleaseDate().setVisible(true);
                    getLblCredits().setVisible(true);
                    getCreditsTextArea().setVisible(true);
                    getBtnSave().setVisible(true);
                }
            });
            buttonGroup.add(rdbtnAll);
        }
        return rdbtnAll;
    }
	private JMenuBar getMenuBar() {
		if (menuBar == null) {
			menuBar = new JMenuBar();
			menuBar.add(getMnFile());
			menuBar.add(getMnEdit());
			menuBar.add(getMnHelp());
		}
		return menuBar;
	}
	private JMenu getMnFile() {
		if (mnFile == null) {
			mnFile = new JMenu("File");
			mnFile.add(getMntmNewAlbum());
			mnFile.add(getMntmNewSong());
			mnFile.add(getSeparator());
			mnFile.add(getMntmOpen());
			mnFile.add(getMntmSave());
			mnFile.add(getSeparator_1());
			mnFile.add(getMntmExit());
		}
		return mnFile;
	}
	private JMenu getMnEdit() {
		if (mnEdit == null) {
			mnEdit = new JMenu("Edit");
		}
		return mnEdit;
	}
	private JMenu getMnHelp() {
		if (mnHelp == null) {
			mnHelp = new JMenu("Help");
		}
		return mnHelp;
	}
	private JMenuItem getMntmNewAlbum() {
		if (mntmNewAlbum == null) {
			mntmNewAlbum = new JMenuItem("New album...");
		}
		return mntmNewAlbum;
	}
	private JMenuItem getMntmNewSong() {
		if (mntmNewSong == null) {
			mntmNewSong = new JMenuItem("New Song...");
			mntmNewSong.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					newSongDialog = new NewSongDialog(frmAlbum, true);
					song = newSongDialog.showDialog();
				}
			});
		}
		return mntmNewSong;
	}
	private JMenuItem getMntmOpen() {
		if (mntmOpen == null) {
			mntmOpen = new JMenuItem("Open...");
		}
		return mntmOpen;
	}
	private JMenuItem getMntmSave() {
		if (mntmSave == null) {
			mntmSave = new JMenuItem("Save...");
		}
		return mntmSave;
	}
	private JMenuItem getMntmExit() {
		if (mntmExit == null) {
			mntmExit = new JMenuItem("Exit");
			mntmExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					System.exit(0);
				}
			});
		}
		return mntmExit;
	}
	private JSeparator getSeparator() {
		if (separator == null) {
			separator = new JSeparator();
		}
		return separator;
	}
	private JSeparator getSeparator_1() {
		if (separator_1 == null) {
			separator_1 = new JSeparator();
		}
		return separator_1;
	}
}
